<?php
// wcf imports
require_once(WCF_DIR.'lib/action/AbstractSecureAction.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbumEditor.class.php');

/**
 * Deletes a gallery album.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	action
 * @category 	Community Framework (commercial)
 */
class UserGalleryAlbumDeleteAction extends AbstractSecureAction {
	/**
	 * album id
	 *
	 * @var integer
	 */
	public $albumID = 0;
	
	/**
	 * album editor object
	 *
	 * @var UserGalleryAlbumEditor
	 */
	public $album = null;
	
	/**
	 * @see Action::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['albumID'])) $this->albumID = intval($_REQUEST['albumID']);
		$this->album = new UserGalleryAlbumEditor($this->albumID);
		if (!$this->album->albumID) {
			throw new IllegalLinkException();
		}
		if (!$this->album->isDeletable()) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * @see Action::execute()
	 */
	public function execute() {
		parent::execute();
		
		// delete album
		$this->album->delete();
		$this->executed();
		
		// forward
		HeaderUtil::redirect('index.php?page=UserGalleryAlbumList&userID='.$this->album->ownerID.SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
}
?>