<?php
// wcf imports
require_once(WCF_DIR.'lib/action/AbstractSecureAction.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoEditor.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoList.class.php');

/**
 * Deletes a gallery photo.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	action
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoDeleteAction extends AbstractSecureAction {
	/**
	 * photo id
	 *
	 * @var integer
	 */
	public $photoID = 0;
	
	/**
	 * photo editor object
	 *
	 * @var UserGalleryPhotoEditor
	 */
	public $photo = null;
	
	/**
	 * @see Action::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['photoID'])) $this->photoID = intval($_REQUEST['photoID']);
		$this->photo = new UserGalleryPhotoEditor($this->photoID);
		if (!$this->photo->photoID) {
			throw new IllegalLinkException();
		}
		if (!$this->photo->isDeletable()) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * @see Action::execute()
	 */
	public function execute() {
		parent::execute();
		
		// delete photo
		$this->photo->delete();
		$this->executed();
		
		// forward
		$photoList = new UserGalleryPhotoList();
		$photoList->sqlConditions .= 'user_gallery.ownerID = '.$this->photo->ownerID;
		if (empty($_REQUEST['ajax'])) {
			if ($photoList->countObjects() > 0 || WCF::getUser()->userID == $this->photo->ownerID) {
				HeaderUtil::redirect('index.php?page=UserGallery&userID='.$this->photo->ownerID.SID_ARG_2ND_NOT_ENCODED);
			}
			else {
				HeaderUtil::redirect('index.php?page=User&userID='.$this->photo->ownerID.SID_ARG_2ND_NOT_ENCODED);
			}
		}
		exit;
	}
}
?>