<?php
// wcf imports
require_once(WCF_DIR.'lib/data/page/location/Location.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhoto.class.php');

/**
 * UserGalleryPhotoLocation is an implementation of Location for the user gallery page.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.page.location
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoLocation implements Location {
	public $cachedPhotoIDs = array();
	public $photos = null;
	
	/**
	 * @see Location::cache()
	 */
	public function cache($location, $requestURI, $requestMethod, $match) {
		$this->cachedPhotoIDs[] = $match[1];
	}
	
	/**
	 * @see Location::get()
	 */
	public function get($location, $requestURI, $requestMethod, $match) {
		if ($this->photos == null) {
			$this->readPhotos();
		}
		
		$photoID = $match[1];
		if (!isset($this->photos[$photoID])) {
			return '';
		}
		
		return WCF::getLanguage()->get($location['locationName'], array(
			'$photo' => '<a href="index.php?page=UserGalleryPhoto&amp;photoID='.$photoID.SID_ARG_2ND.'">'.StringUtil::encodeHTML($this->photos[$photoID]->title).'</a>',
			'$user' => '<a href="index.php?page=UserGallery&amp;userID='.$this->photos[$photoID]->ownerID.SID_ARG_2ND.'">'.StringUtil::encodeHTML($this->photos[$photoID]->username).'</a>'
		));
	}
	
	/**
	 * Gets photos.
	 */
	protected function readPhotos() {
		$this->photos = array();
		
		if (!count($this->cachedPhotoIDs)) {
			return;
		}
		
		$sql = "SELECT		user_gallery.*, user_table.username
			FROM		wcf".WCF_N."_user_gallery user_gallery
			LEFT JOIn	wcf".WCF_N."_user user_table
			ON		(user_table.userID = user_gallery.ownerID)
			WHERE		user_gallery.photoID IN (".implode(',', $this->cachedPhotoIDs).")";
		$result = WCF::getDB()->sendQuery($sql);
		while ($row = WCF::getDB()->fetchArray($result)) {
			$this->photos[$row['photoID']] = new UserGalleryPhoto(null, $row);
		}
	}
}
?>