<?php
// wcf imports
require_once(WCF_DIR.'lib/data/DatabaseObject.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhoto.class.php');

/**
 * Represents a gallery album.
 *
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery.album
 * @category 	Community Framework (commercial)
 */
class UserGalleryAlbum extends DatabaseObject {
	/**
	 * cover photo
	 * 
	 * @var	UserGalleryPhoto
	 */
	public $cover = null;

	/**
	 * Creates a new UserGalleryAlbum object.
	 *
	 * @param	integer		$albumID
	 * @param 	array<mixed>	$row
	 */
	public function __construct($albumID, $row = null) {
		if ($albumID !== null) {
			$sql = "SELECT		cover.*, user_gallery_album.*
				FROM 		wcf".WCF_N."_user_gallery_album user_gallery_album
				LEFT JOIN	wcf".WCF_N."_user_gallery cover
				ON		(cover.photoID = user_gallery_album.coverPhotoID)
				WHERE 		user_gallery_album.albumID = ".$albumID;
			$row = WCF::getDB()->getFirstRow($sql);
		}
		parent::__construct($row);
	}
	
	/**
	 * @see DatabaseObject::handleData()
	 */
	protected function handleData($data) {
		$this->data = $data;
		
		if ($this->coverPhotoID && $this->photoID) {
			$this->cover = new UserGalleryPhoto(null, $data);
		}
		else  {
			$this->cover = UserGalleryPhoto::getEmptyPhotoObject();
		}
	}
	
	/**
	 * Returns the album cover photo.
	 * 
	 * @return	UserGalleryPhoto
	 */
	public function getCoverPhoto() {
		return $this->cover;
	}
	
	/**
	 * Returns the title of this album.
	 * 
	 * @return	string
	 */
	public function __toString() {
		return $this->title;
	}
	
	/**
	 * Returns the formatted description of this album.
	 * 
	 * @return	string
	 */
	public function getFormattedDescription() {
		if ($this->description) {
			return nl2br(StringUtil::encodeHTML($this->description));
		}
		
		return '';
	}
	
	/**
	 * Returns a list of all albums of a user.
	 * 
	 * @param	integer			$userID
	 * @return	array<UserGalleryAlbum>
	 */
	public static function getAlbums($userID) {
		$albums = array();
		$sql = "SELECT		*
			FROM 		wcf".WCF_N."_user_gallery_album
			WHERE 		ownerID = ".$userID."
			ORDER BY	title";
		$result = WCF::getDB()->sendQuery($sql);
		while ($row = WCF::getDB()->fetchArray($result)) {
			$albums[$row['albumID']] = new UserGalleryAlbum(null, $row);
		}
		
		return $albums;
	}
	
	/**
	 * Returns a list of all photos in this album.
	 * 
	 * @return	array<UserGalleryPhoto>
	 */
	public function getPhotos() {
		require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhoto.class.php');
		$photos = array();
		$sql = "SELECT		*
			FROM 		wcf".WCF_N."_user_gallery
			WHERE 		albumID = ".$this->albumID."
			ORDER BY	title";
		$result = WCF::getDB()->sendQuery($sql);
		while ($row = WCF::getDB()->fetchArray($result)) {
			$photos[$row['photoID']] = new UserGalleryPhoto(null, $row);
		}
		
		return $photos;
	}
	
	/**
	 * Returns true, if the active user can edit this album.
	 * 
	 * @return	boolean
	 */
	public function isEditable() {
		if (($this->ownerID == WCF::getUser()->userID && WCF::getUser()->getPermission('user.gallery.canUseGallery')) || WCF::getUser()->getPermission('mod.gallery.canEditAlbum')) {
			return true;
		}
		return false;
	}
	
	/**
	 * Returns true, if the active user can delete this album.
	 * 
	 * @return	boolean
	 */
	public function isDeletable() {
		if (($this->ownerID == WCF::getUser()->userID && WCF::getUser()->getPermission('user.gallery.canUseGallery')) || WCF::getUser()->getPermission('mod.gallery.canDeleteAlbum')) {
			return true;
		}
		return false;
	}
	
	/**
	 * Counts the albums of a user.
	 * 
	 * @param	integer		$userID
	 * @return	integer
	 */
	public static function countUserAlbums($userID = null) {
		if ($userID === null) $userID = WCF::getUser()->userID;
		
		$sql = "SELECT	COUNT(*) AS albums
			FROM	wcf".WCF_N."_user_gallery_album
			WHERE	ownerID = ".$userID;
		$row = WCF::getDB()->getFirstRow($sql);
		return $row['albums'];
	}
}
?>