<?php
// wcf imports
require_once(WCF_DIR.'lib/form/UserGalleryPhotoAddForm.class.php');

/**
 * Shows the form for editing gallery photos.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	form
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoEditForm extends UserGalleryPhotoAddForm {
	/**
	 * photo id
	 * 
	 * @var	integer
	 */
	public $photoID = 0;
	
	/**
	 * photo editor object
	 * 
	 * @var	UserGalleryPhotoEditor
	 */
	public $photo = null;
	
	/**
	 * @see	Page::readParameters()
	 */
	public function readParameters() {
		AbstractForm::readParameters();
		
		if (isset($_REQUEST['photoID'])) $this->photoID = intval($_REQUEST['photoID']);
		$this->photo = new UserGalleryPhotoEditor($this->photoID);
		if (!$this->photo->photoID) {
			throw new IllegalLinkException();
		}
		if (!$this->photo->isEditable()) {
			throw new PermissionDeniedException();
		}
		
		// get profile frame
		$this->frame = new UserProfileFrame($this, $this->photo->ownerID);
		
		// get album id
		if (isset($_REQUEST['albumID'])) $this->albumID = intval($_REQUEST['albumID']);
	}
	
	/**
	 * Does nothing.
	 */
	protected function validateUpload() {}
	
	/**
	 * @see	Form::save()
	 */
	public function save() {
		AbstractForm::save();
		
		// update photo
		$this->photo->update($this->title, $this->description, $this->albumID);
		
		// save tags
		if (MODULE_TAGGING == 1) {
			$tagArray = TaggingUtil::splitString($this->tags);
			$this->photo->updateTags($tagArray);
		}
		$this->saved();
		
		// show success message
		WCF::getTPL()->assign('success', true);
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		if (!count($_POST)) {
			$this->title = $this->photo->title;
			$this->description = $this->photo->description;
			$this->albumID = $this->photo->albumID;
			$this->tags = TaggingUtil::buildString($this->photo->getTags(array((count(Language::getAvailableContentLanguages()) > 0 ? WCF::getLanguage()->getLanguageID() : 0))));
		}
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'action' => 'edit',
			'photoID' => $this->photoID,
			'photo' => $this->photo
		));
	}
}
?>