<?php
// wcf imports
require_once(WCF_DIR.'lib/page/MultipleLinkPage.class.php');
require_once(WCF_DIR.'lib/data/user/UserProfileFrame.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbumList.class.php');

/**
 * Shows the list of all albums of a user gallery.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	page
 * @category 	Community Framework (commercial)
 */
class UserGalleryAlbumListPage extends MultipleLinkPage {
	// system
	public $templateName = 'userGalleryAlbumList';
	
	/**
	 * list of gallery albums
	 * 
	 * @var	UserGalleryAlbumList
	 */
	public $albumList = null;
	
	/**
	 * user profile frame
	 * 
	 * @var UserProfileFrame
	 */
	public $frame = null;
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get profile frame
		$this->frame = new UserProfileFrame($this);
		
		// init photo list
		$this->albumList = new UserGalleryAlbumList();
		$this->albumList->sqlConditions .= 'user_gallery_album.ownerID = '.$this->frame->getUserID();
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		// read objects
		$this->albumList->sqlOffset = ($this->pageNo - 1) * $this->itemsPerPage;
		$this->albumList->sqlLimit = $this->itemsPerPage;
		$this->albumList->readObjects();
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */
	public function countItems() {
		parent::countItems();
		
		return $this->albumList->countObjects();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		if ($this->items == 0 && WCF::getUser()->userID != $this->frame->getUserID()) {
			throw new IllegalLinkException();
		}
		
		$this->frame->assignVariables();
		WCF::getTPL()->assign(array(
			'albums' => $this->albumList->getObjects(),
			'allowSpidersToIndexThisPage' => true
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		UserProfileMenu::getInstance()->setActiveMenuItem('wcf.user.profile.menu.link.gallery');
		
		// check permission
		WCF::getUser()->checkPermission('user.gallery.canViewGallery');
		
		if (!MODULE_USER_GALLERY || !$this->frame->getUser()->getPermission('user.gallery.canUseGallery')) {
			throw new IllegalLinkException();
		}
		
		parent::show();
	}
}
?>