<?php
// wcf imports
require_once(WCF_DIR.'lib/page/MultipleLinkPage.class.php');
require_once(WCF_DIR.'lib/data/user/UserProfileFrame.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhoto.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbum.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/comment/UserGalleryPhotoCommentList.class.php');

/**
 * Shows a detailed view of a user gallery photo.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	page
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoPage extends MultipleLinkPage {
	// system
	public $templateName = 'userGalleryPhoto';
	
	/**
	 * photo id
	 *
	 * @var	integer
	 */
	public $photoID = 0;
	
	/**
	 * photo object
	 * 
	 * @var	UserGalleryPhoto
	 */
	public $photo = null;
	
	/**
	 * album object
	 * 
	 * @var	UserGalleryAlbum
	 */
	public $album = null;
	
	/**
	 * list of comments
	 *
	 * @var UserGalleryPhotoCommentList
	 */
	public $commentList = null;
	
	/**
	 * image size
	 *
	 * @var string
	 */
	public $size = '';
	
	/**
	 * comment id
	 * 
	 * @var	integer
	 */
	public $commentID = 0;
	
	/**
	 * comment object
	 * 
	 * @var	UserGalleryPhotoComment
	 */
	public $comment = null;
	
	/**
	 * action
	 * 
	 * @var	string
	 */
	public $action = '';
	
	/**
	 * selected view
	 * 
	 * @var	string
	 */
	public $view = '';
	
	/**
	 * previous photo
	 * 
	 * @var	UserGalleryPhoto
	 */
	public $previousPhoto = null;
	
	/**
	 * next photo
	 * 
	 * @var	UserGalleryPhoto
	 */
	public $nextPhoto = null;
	
	/**
	 * user profile frame
	 * 
	 * @var UserProfileFrame
	 */
	public $frame = null;
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get photo
		if (isset($_REQUEST['photoID'])) $this->photoID = intval($_REQUEST['photoID']);
		$this->photo = new UserGalleryPhoto($this->photoID);
		if (!$this->photo->photoID) {
			throw new IllegalLinkException();
		}
		
		if (isset($_REQUEST['view'])) $this->view = $_REQUEST['view'];
		if (isset($_REQUEST['size'])) $this->size = $_REQUEST['size'];
		if (isset($_REQUEST['errorField'])) $this->errorField = $_REQUEST['errorField'];
		if (isset($_REQUEST['action'])) $this->action = $_REQUEST['action'];
		if (isset($_REQUEST['commentID'])) $this->commentID = intval($_REQUEST['commentID']);
		if ($this->commentID != 0) {
			$this->comment = new UserGalleryPhotoComment($this->commentID);
			if (!$this->comment->commentID || $this->comment->photoID != $this->photoID) {
				throw new IllegalLinkException();
			}
			
			// check permissions
			if ($this->action == 'edit' && !$this->comment->isEditable()) {
				throw new PermissionDeniedException();
			}
						
			// get page number
			$sql = "SELECT	COUNT(*) AS comments
				FROM 	wcf".WCF_N."_user_gallery_comment
				WHERE 	photoID = ".$this->photoID."
					AND time >= ".$this->comment->time;
			$result = WCF::getDB()->getFirstRow($sql);
			$this->pageNo = intval(ceil($result['comments'] / $this->itemsPerPage));
		}
		
		// get profile frame
		$this->frame = new UserProfileFrame($this, $this->photo->ownerID);
		
		// init comment list
		$this->commentList = new UserGalleryPhotoCommentList();
		$this->commentList->sqlConditions .= 'user_gallery_comment.photoID = '.$this->photoID;
		$this->commentList->sqlOrderBy = 'user_gallery_comment.time DESC';
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		// read objects
		$this->commentList->sqlOffset = ($this->pageNo - 1) * $this->itemsPerPage;
		$this->commentList->sqlLimit = $this->itemsPerPage;
		$this->commentList->readObjects();

		// get album
		if ($this->photo->albumID != 0) {
			$this->album = new UserGalleryAlbum($this->photo->albumID);
		}
		
		// update views
		if (!WCF::getSession()->spiderID && $this->size == '') {
			$sql = "UPDATE	wcf".WCF_N."_user_gallery
				SET	views = views + 1
				WHERE	photoID = ".$this->photoID;
			WCF::getDB()->sendQuery($sql);
		}
		
		// validate size
		switch ($this->size) {
			case 'quadratic':
			case 'tiny':
			case 'small':
			case 'medium':
				break;
			default: $this->size = 'medium';
		}
		
		// get previous photo
		$sql = "SELECT		*
			FROM		wcf".WCF_N."_user_gallery
			WHERE		".(($this->view == 'album' && $this->photo->albumID != 0) ? "albumID = ".$this->photo->albumID : "ownerID = ".$this->frame->getUserID())."
					AND (
						uploadTime > ".$this->photo->uploadTime."
						OR (uploadTime = ".$this->photo->uploadTime." AND photoID < ".$this->photo->photoID.")
					)
			ORDER BY	uploadTime ASC, photoID DESC";
		$this->previousPhoto = new UserGalleryPhoto(null, WCF::getDB()->getFirstRow($sql));
		if (!$this->previousPhoto->photoID) $this->previousPhoto = null;
		
		// get next photo
		$sql = "SELECT		*
			FROM		wcf".WCF_N."_user_gallery
			WHERE		".(($this->view == 'album' && $this->photo->albumID != 0) ? "albumID = ".$this->photo->albumID : "ownerID = ".$this->frame->getUserID())."
					AND (
						uploadTime < ".$this->photo->uploadTime."
						OR (uploadTime = ".$this->photo->uploadTime." AND photoID > ".$this->photo->photoID.")
					)
			ORDER BY	uploadTime DESC, photoID ASC";
		$this->nextPhoto = new UserGalleryPhoto(null, WCF::getDB()->getFirstRow($sql));
		if (!$this->nextPhoto->photoID) $this->nextPhoto = null;
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */
	public function countItems() {
		parent::countItems();
		
		return $this->commentList->countObjects();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		// init form
		if ($this->photo->isCommentable()) {
			if ($this->action == 'edit') {
				require_once(WCF_DIR.'lib/form/UserGalleryPhotoCommentEditForm.class.php');
				new UserGalleryPhotoCommentEditForm($this->comment);
			}
			else {
				require_once(WCF_DIR.'lib/form/UserGalleryPhotoCommentAddForm.class.php');
				new UserGalleryPhotoCommentAddForm($this->photo);
			}
		}
		
		$this->frame->assignVariables();
		WCF::getTPL()->assign(array(
			'photo' => $this->photo,
			'photoID' => $this->photoID,
			'tags' => (MODULE_TAGGING ? $this->photo->getTags(WCF::getSession()->getVisibleLanguageIDArray()) : array()),
			'album' => $this->album,
			'size' => $this->size,
			'comments' => $this->commentList->getObjects(),
			'action' => $this->action,
			'commentID' => $this->commentID,
			'view' => $this->view,
			'previousPhoto' => $this->previousPhoto,
			'nextPhoto' => $this->nextPhoto,
			'templateName' => $this->templateName,
			'allowSpidersToIndexThisPage' => true
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		UserProfileMenu::getInstance()->setActiveMenuItem('wcf.user.profile.menu.link.gallery');
		
		// check permission
		WCF::getUser()->checkPermission('user.gallery.canViewGallery');
		
		if (!MODULE_USER_GALLERY || !$this->frame->getUser()->getPermission('user.gallery.canUseGallery')) {
			throw new IllegalLinkException();
		}
		
		parent::show();
	}
}
?>