<?php
// wcf imports
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');

/**
 * Shows the lastest gallery entries.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	system.event.listener
 * @category 	Community Framework (commercial)
 */
class UserPageGalleryListener implements EventListener {
	/**
	 * @see EventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		if (MODULE_USER_GALLERY == 1 && PROFILE_SHOW_LAST_GALLERY_PHOTOS == 1 && WCF::getUser()->getPermission('user.gallery.canViewGallery') && $eventObj->frame->getUser()->getPermission('user.gallery.canUseGallery')) {
			// get entries
			require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoList.class.php');
			$photoList = new UserGalleryPhotoList();
			$photoList->sqlConditions .= 'user_gallery.ownerID = '.$eventObj->frame->getUserID();
			$count = $photoList->countObjects();
			if ($count > 0) {
				$photoList->sqlLimit = 5;
				$photoList->readObjects();
				
				WCF::getTPL()->assign(array(
					'user' => $eventObj->frame->getUser(),
					'photos' => $photoList->getObjects(),
					'galleryEntries' => $count
				));
				WCF::getTPL()->append('additionalContent3', WCF::getTPL()->fetch('userProfileGallery'));
			}
		}
	}
}
?>