<?php
// wcf imports
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');

/**
 * Removes the gallery tab.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	system.event.listener
 * @category 	Community Framework (commercial)
 */
class UserProfileFrameGalleryTabListener implements EventListener {
	/**
	 * @see EventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		if ($eventName == 'init') {
			$eventObj->sqlSelects .= "(SELECT COUNT(*) FROM wcf".WCF_N."_user_gallery WHERE ownerID = user.userID) AS photos,";
		}
		else if ($eventName == 'assignVariables') {
			if (!WCF::getUser()->getPermission('user.gallery.canViewGallery') || !$eventObj->getUser()->getPermission('user.gallery.canUseGallery') || (!$eventObj->getUser()->photos && (WCF::getUser()->userID != $eventObj->userID || !WCF::getUser()->getPermission('user.gallery.canUseGallery')))) {
				// remove gallery overview tab
				foreach (UserProfileMenu::getInstance()->menuItems as $parentMenuItem => $items) {
					foreach ($items as $key => $item) {
						if ($item['menuItem'] == 'wcf.user.profile.menu.link.gallery') {
							unset(UserProfileMenu::getInstance()->menuItems[$parentMenuItem][$key]);
						}
					}
				}
			}
		}
	}
}
?>