<?php
// wcf imports
require_once(WCF_DIR.'lib/action/AbstractSecureAction.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/comment/UserGalleryPhotoCommentEditor.class.php');

/**
 * Deletes a gallery photo comment.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	action
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotoCommentDeleteAction extends AbstractSecureAction {
	/**
	 * comment id
	 *
	 * @var integer
	 */
	public $commentID = 0;
	
	/**
	 * comment editor object
	 *
	 * @var UserGalleryPhotoCommentEditor
	 */
	public $comment = null;
	
	/**
	 * @see Action::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['commentID'])) $this->commentID = intval($_REQUEST['commentID']);
		$this->comment = new UserGalleryPhotoCommentEditor($this->commentID);
		if (!$this->comment->commentID) {
			throw new IllegalLinkException();
		}
		if (!$this->comment->isDeletable()) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * @see Action::execute()
	 */
	public function execute() {
		parent::execute();
		
		// delete comment
		$this->comment->delete();
		$this->executed();
		
		// forward
		HeaderUtil::redirect('index.php?page=UserGalleryPhoto&photoID='.$this->comment->photoID.SID_ARG_2ND_NOT_ENCODED.'#comments');
		exit;
	}
}
?>