<?php
// wcf imports
require_once(WCF_DIR.'lib/form/AbstractForm.class.php');
require_once(WCF_DIR.'lib/data/user/UserProfileFrame.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbumEditor.class.php');

/**
 * Shows the form for adding new gallery albums.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	form
 * @category 	Community Framework (commercial)
 */
class UserGalleryAlbumAddForm extends AbstractForm {
	// system
	public $templateName = 'userGalleryAlbumAdd';
	
	/**
	 * number of free albums
	 * 
	 * @var	integer
	 */
	public $freeAlbums = 0;
	
	// form parameters
	public $title = '';
	public $description = '';
	
	/**
	 * user profile frame
	 * 
	 * @var UserProfileFrame
	 */
	public $frame = null;
	
	/**
	 * @see	Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get profile frame
		$this->frame = new UserProfileFrame($this, WCF::getUser()->userID);
		
		// check permissions
		WCF::getUser()->checkPermission('user.gallery.canUseGallery');
		
		// get number of free albums
		$this->freeAlbums = WCF::getUser()->getPermission('user.gallery.maxAlbums') - UserGalleryAlbum::countUserAlbums();
		if ($this->freeAlbums <= 0) {
			throw new NamedUserException(WCF::getLanguage()->get('wcf.user.gallery.album.error.tooManyAlbums'));
		}
	}
	
	/**
	 * @see	Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		if (isset($_POST['title'])) $this->title = StringUtil::trim($_POST['title']);
		if (isset($_POST['description'])) $this->description = StringUtil::trim($_POST['description']);
	}
	
	/**
	 * @see	Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		if (empty($this->title)) {
			throw new UserInputException('title');
		}
	}
	
	/**
	 * @see	Form::save()
	 */
	public function save() {
		parent::save();
		
		// save
		UserGalleryAlbumEditor::create(WCF::getUser()->userID, $this->title, $this->description);
		$this->saved();
			
		// forward
		HeaderUtil::redirect('index.php?page=UserGalleryAlbumList&userID='.$this->frame->getUserID().SID_ARG_2ND_NOT_ENCODED);
		exit;
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		$this->frame->assignVariables();
		WCF::getTPL()->assign(array(
			'title' => $this->title,
			'description' => $this->description,
			'action' => 'add',
			'freeAlbums' => $this->freeAlbums
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		UserProfileMenu::getInstance()->setActiveMenuItem('wcf.user.profile.menu.link.gallery');
		
		// check permission
		WCF::getUser()->checkPermission('user.gallery.canUseGallery');
		
		if (!MODULE_USER_GALLERY) {
			throw new IllegalLinkException();
		}
		
		parent::show();
	}
}
?>