<?php
// wcf imports
require_once(WCF_DIR.'lib/data/page/location/UserLocation.class.php');

/**
 * UserGalleryLocation is an implementation of Location for the user gallery page.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.page.location
 * @category 	Community Framework (commercial)
 */
class UserGalleryLocation extends UserLocation {
	/**
	 * @see Location::get()
	 */
	public function get($location, $requestURI, $requestMethod, $match) {
		if ($this->users == null) {
			$this->readUsers();
		}
		
		$userID = $match[1];
		if (!isset($this->users[$userID])) {
			return '';
		}
		
		return WCF::getLanguage()->get($location['locationName'], array('$user' => '<a href="index.php?page=UserGallery&amp;userID='.$userID.SID_ARG_2ND.'">'.StringUtil::encodeHTML($this->users[$userID]).'</a>'));
	}
}
?>