<?php
// wcf imports
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoList.class.php');
require_once(WCF_DIR.'lib/data/tag/TagEngine.class.php');

/**
 * Represents a list of tagged gallery photos.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery
 * @category 	Community Framework (commercial)
 */
class TaggedUserGalleryPhotoList extends UserGalleryPhotoList {
	/**
	 * tag id
	 * 
	 * @var	integer
	 */
	public $tagID = 0;
	
	/**
	 * taggable object
	 * 
	 * @var	Taggable
	 */
	public $taggable = null;

	/**
	 * Creates a new TaggedUserGalleryPhotoList object.
	 */
	public function __construct($tagID) {
		$this->tagID = $tagID;
		$this->taggable = TagEngine::getInstance()->getTaggable('com.woltlab.wcf.user.gallery.photo');
	}
	
	/**
	 * @see DatabaseObjectList::countObjects()
	 */
	public function countObjects() {
		if (!empty($this->sqlConditions)) {
			$sql = "SELECT	COUNT(*) AS count
				FROM	wcf".WCF_N."_tag_to_object tag_to_object,
					wcf".WCF_N."_user_gallery user_gallery
				WHERE	tag_to_object.tagID = ".$this->tagID."
					AND tag_to_object.taggableID = ".$this->taggable->getTaggableID()."
					AND user_gallery.photoID = tag_to_object.objectID
					AND ".$this->sqlConditions;
		}
		else {
			$sql = "SELECT	COUNT(*) AS count
				FROM	wcf".WCF_N."_tag_to_object
				WHERE	tagID = ".$this->tagID."
					AND taggableID = ".$this->taggable->getTaggableID();
		}
		$row = WCF::getDB()->getFirstRow($sql);
		return $row['count'];
	}
	
	/**
	 * @see DatabaseObjectList::readObjects()
	 */
	public function readObjects() {
		$sql = "SELECT	".(!empty($this->sqlSelects) ? $this->sqlSelects.',' : '')."
				user_gallery.*
			FROM	wcf".WCF_N."_tag_to_object tag_to_object,
				wcf".WCF_N."_user_gallery user_gallery
			".$this->sqlJoins."
			WHERE	tag_to_object.tagID = ".$this->tagID."
				AND tag_to_object.taggableID = ".$this->taggable->getTaggableID()."
				AND user_gallery.photoID = tag_to_object.objectID
				".(!empty($this->sqlConditions) ? "AND ".$this->sqlConditions : '')."
				".(!empty($this->sqlOrderBy) ? "ORDER BY ".$this->sqlOrderBy : '');
		$result = WCF::getDB()->sendQuery($sql, $this->sqlLimit, $this->sqlOffset);
		while ($row = WCF::getDB()->fetchArray($result)) {
			$this->photos[] = new UserGalleryPhoto(null, $row);
		}
	}
}
?>