<?php
// wcf imports
require_once(WCF_DIR.'lib/data/user/gallery/TaggedUserGalleryPhotoList.class.php');

/**
 * Represents a list of tagged gallery photos.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery
 * @category 	Community Framework (commercial)
 */
class TaggedUserGalleryPhotoOverviewList extends TaggedUserGalleryPhotoList {
	/**
	 * Creates a new TaggedUserGalleryPhotoOverviewList object.
	 */
	public function __construct($tagID) {
		$this->sqlSelects = 'user_table.username';
		$this->sqlJoins = "LEFT JOIN wcf".WCF_N."_user user_table ON (user_table.userID = user_gallery.ownerID)";
		parent::__construct($tagID);
	}
}
?>