<?php
// wcf imports
require_once(WCF_DIR.'lib/data/tag/TagList.class.php');

/**
 * Represents a list of tags.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery
 * @category 	Community Framework (commercial)
 */
class UserGalleryTagList extends TagList {
	/**
	 * user id
	 *
	 * @var	integer
	 */
	public $userID = 0;
	
	/**
	 * Creates a new UserGalleryTagList object.
	 *
	 * @param	integer		$userID
	 * @param	array<integer>	$languageIDArray
	 */
	public function __construct($userID, $languageIDArray = array()) {
		parent::__construct(array('com.woltlab.wcf.user.gallery.photo'), $languageIDArray);
		$this->userID = $userID;
	}
	
	/**
	 * Gets the tag ids.
	 */
	public function getTagsIDArray() {
		$tagIDArray = array();
		$sql = "SELECT		COUNT(*) AS counter, object.tagID
			FROM 		wcf".WCF_N."_user_gallery gallery,
					wcf".WCF_N."_tag_to_object object
			WHERE 		gallery.ownerID = ".$this->userID."
					AND object.taggableID IN (".implode(',', $this->taggableIDArray).")
					AND object.languageID IN (".implode(',', $this->languageIDArray).")
					AND object.objectID = gallery.photoID
			GROUP BY 	object.tagID
			".(!empty($this->sqlOrderBy) ? "ORDER BY ".$this->sqlOrderBy : '');
		$result = WCF::getDB()->sendQuery($sql, $this->sqlLimit, $this->sqlOffset);
		while ($row = WCF::getDB()->fetchArray($result)) {
			if ($row['counter'] > $this->maxCounter) $this->maxCounter = $row['counter'];
			if ($row['counter'] < $this->minCounter) $this->minCounter = $row['counter'];
			$tagIDArray[$row['tagID']] = $row['counter'];
		}
		
		return $tagIDArray;
	}
}
?>