<?php
// wcf imports
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbum.class.php');

/**
 * Provides functions to manage gallery albums.
 *
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	data.user.gallery.album
 * @category 	Community Framework (commercial)
 */
class UserGalleryAlbumEditor extends UserGalleryAlbum {
	/**
	 * Creates a new album.
	 *
	 * @param	integer		$ownerID
	 * @param	string		$title
	 * @param	string		$description
	 * @return	UserGalleryAlbumEditor
	 */
	public static function create($ownerID, $title, $description = '') {
		$sql = "INSERT INTO	wcf".WCF_N."_user_gallery_album
					(ownerID, title, description, lastUpdateTime)
			VALUES		(".$ownerID.", '".escapeString($title)."', '".escapeString($description)."', ".TIME_NOW.")";
		WCF::getDB()->sendQuery($sql);
		
		// get new id
		$albumID = WCF::getDB()->getInsertID("wcf".WCF_N."_user_gallery_album", 'albumID');
		return new UserGalleryAlbumEditor($albumID);
	}
	
	/**
	 * Updates this album.
	 *
	 * @param	string		$title
	 * @param	string		$description
	 * @param	integer		$coverPhotoID
	 */
	public function update($title, $description = '', $coverPhotoID = 0) {
		$sql = "UPDATE	wcf".WCF_N."_user_gallery_album
			SET	title = '".escapeString($title)."',
				description = '".escapeString($description)."',
				coverPhotoID = ".$coverPhotoID."
			WHERE	albumID = ".$this->albumID;
		WCF::getDB()->sendQuery($sql);
	}
	
	/**
	 * Deletes this album.
	 */
	public function delete() {
		// update album photos
		$sql = "UPDATE	wcf".WCF_N."_user_gallery
			SET	albumID = 0
			WHERE	albumID = ".$this->albumID;
		WCF::getDB()->sendQuery($sql);
		
		// delete album
		$sql = "DELETE FROM	wcf".WCF_N."_user_gallery_album
			WHERE		albumID = ".$this->albumID;
		WCF::getDB()->sendQuery($sql);
	}
}
?>