<?php
// wcf imports
require_once(WCF_DIR.'lib/page/AbstractPage.class.php');
require_once(WCF_DIR.'lib/data/user/UserProfileFrame.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoList.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbumList.class.php');

/**
 * Shows the overview page of a user gallery.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	page
 * @category 	Community Framework (commercial)
 */
class UserGalleryPage extends AbstractPage {
	// system
	public $templateName = 'userGallery';
	
	/**
	 * list of gallery photos
	 *
	 * @var UserGalleryPhotoList
	 */
	public $photoList = null;
	
	/**
	 * list of all photos
	 * 
	 * @var	UserGalleryPhoto
	 */
	public $allPhotos = array();
	
	/**
	 * list of gallery albums
	 * 
	 * @var	UserGalleryAlbumList
	 */
	public $albumList = null;
	
	/**
	 * number of albums
	 * 
	 * @var	integer
	 */
	public $albumItems = 0;
	
	/**
	 * user profile frame
	 * 
	 * @var UserProfileFrame
	 */
	public $frame = null;
	
	/**
	 * tag list object
	 *
	 * @var TagList
	 */
	public $tagList = null;
	
	/**
	 * list of tags
	 * 
	 * @var	array
	 */
	public $tags = array();
	
	/**
	 * numbers of photos
	 * 
	 * @var	integer
	 */
	public $items = 0;
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get profile frame
		$this->frame = new UserProfileFrame($this);
		
		// init photo list
		$this->photoList = new UserGalleryPhotoList();
		$this->photoList->sqlConditions .= 'user_gallery.ownerID = '.$this->frame->getUserID();
		// init photo list
		$this->albumList = new UserGalleryAlbumList();
		$this->albumList->sqlConditions .= 'user_gallery_album.ownerID = '.$this->frame->getUserID();
		
		// init tag list
		if (MODULE_TAGGING) {
			require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryTagList.class.php');
			$this->tagList = new UserGalleryTagList($this->frame->getUserID(), WCF::getSession()->getVisibleLanguageIDArray());
		}
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		// read all
		$this->items = $this->photoList->countObjects();
		$this->photoList->sqlLimit = 100;
		$this->photoList->readObjects();
		$this->allPhotos = $this->photoList->getObjects();
		$this->photoList->photos = array();
		
		// read objects
		$this->photoList->sqlLimit = 15;
		$this->photoList->readObjects();
		
		// read albums
		if (($this->albumItems = $this->albumList->countObjects())) {
			$this->albumList->sqlLimit = 5;
			$this->albumList->readObjects();
		}
		
		if (MODULE_TAGGING) {
			$this->tagList->readObjects();
			$this->tags = $this->tagList->getObjects();
		}
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		$this->frame->assignVariables();
		WCF::getTPL()->assign(array(
			'items' => $this->items,
			'allPhotos' => $this->allPhotos,
			'photos' => $this->photoList->getObjects(),
			'albumItems' => $this->albumItems,
			'albums' => $this->albumList->getObjects(),
			'availableTags' => $this->tags,
			'availableAlbums' => UserGalleryAlbum::getAlbums(WCF::getUser()->userID),
			'allowSpidersToIndexThisPage' => true
		));
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		UserProfileMenu::getInstance()->setActiveMenuItem('wcf.user.profile.menu.link.gallery');
		
		// check permission
		WCF::getUser()->checkPermission('user.gallery.canViewGallery');
		
		if (!MODULE_USER_GALLERY || !$this->frame->getUser()->getPermission('user.gallery.canUseGallery')) {
			throw new IllegalLinkException();
		}
		
		parent::show();
	}
}
?>