<?php
// wcf imports
require_once(WCF_DIR.'lib/page/SortablePage.class.php');
require_once(WCF_DIR.'lib/data/user/UserProfileFrame.class.php');
require_once(WCF_DIR.'lib/data/user/gallery/album/UserGalleryAlbum.class.php');

/**
 * Shows a list of tagged photos.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	page
 * @category 	Community Framework (commercial)
 */
class UserGalleryPhotosPage extends SortablePage {
	// system
	public $templateName = 'userGalleryPhotos';
	public $defaultSortField = 'uploadTime';
	public $defaultSortOrder = 'DESC';
	
	/**
	 * album id
	 *
	 * @var	integer
	 */
	public $albumID = 0;
	
	/**
	 * album object
	 * 
	 * @var	UserGalleryAlbum
	 */
	public $album = null;
	
	/**
	 * list of gallery photos
	 *
	 * @var UserGalleryPhotoList
	 */
	public $photoList = null;
	
	/**
	 * list of all photos
	 * 
	 * @var	UserGalleryPhoto
	 */
	public $allPhotos = array();
	
	/**
	 * tag id
	 *
	 * @var integer
	 */
	public $tagID = 0;
	
	/**
	 * tag object
	 *
	 * @var Tag
	 */
	public $tag = null;
	
	/**
	 * list of tags
	 * 
	 * @var	array
	 */
	public $tags = array();
	
	// parameters
	public $filterByAlbumID = 0;
	public $filterByTagID = 0;
	
	/**
	 * user profile frame
	 * 
	 * @var UserProfileFrame
	 */
	public $frame = null;
	
	/**
	 * @see Page::readParameters()
	 */
	public function readParameters() {
		parent::readParameters();
		
		// get album
		if (isset($_REQUEST['albumID'])) {
			$this->albumID = intval($_REQUEST['albumID']);
			$this->album = new UserGalleryAlbum($this->albumID);
			if (!$this->album->albumID) {
				throw new IllegalLinkException();
			}
		}
		
		// get profile frame
		$this->frame = new UserProfileFrame($this, ($this->albumID ? $this->album->ownerID : null));
		
		// get tag
		if (isset($_REQUEST['tagID'])) $this->tagID = intval($_REQUEST['tagID']);
		
		// init photo list
		if (MODULE_TAGGING && $this->tagID) {
			require_once(WCF_DIR.'lib/data/tag/TagEngine.class.php');
			$this->tag = TagEngine::getInstance()->getTagByID($this->tagID);
			if ($this->tag === null) {
				throw new IllegalLinkException();
			}
			require_once(WCF_DIR.'lib/data/user/gallery/TaggedUserGalleryPhotoList.class.php');
			$this->photoList = new TaggedUserGalleryPhotoList($this->tagID);
		}
		else {
			require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryPhotoList.class.php');
			$this->photoList = new UserGalleryPhotoList();
		}
		$this->photoList->sqlConditions .= 'user_gallery.ownerID = '.$this->frame->getUserID();
		if ($this->albumID) {
			$this->photoList->sqlConditions .= ' AND user_gallery.albumID = '.$this->albumID;
		}
		
		// init tag list
		if (MODULE_TAGGING) {
			require_once(WCF_DIR.'lib/data/user/gallery/UserGalleryTagList.class.php');
			$this->tagList = new UserGalleryTagList($this->frame->getUserID(), WCF::getSession()->getVisibleLanguageIDArray());
		}
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		// read all
		$this->photoList->sqlLimit = 100;
		$this->photoList->sqlOrderBy = 'user_gallery.'.$this->sortField.' '.$this->sortOrder;
		$this->photoList->readObjects();
		$this->allPhotos = $this->photoList->getObjects();
		$this->photoList->photos = array();
		
		// read objects
		$this->photoList->sqlOffset = ($this->pageNo - 1) * $this->itemsPerPage;
		$this->photoList->sqlLimit = $this->itemsPerPage;
		$this->photoList->readObjects();
		
		if (MODULE_TAGGING) {
			$this->tagList->readObjects();
			$this->tags = $this->tagList->getObjects();
		}
	}
	
	/**
	 * @see MultipleLinkPage::countItems()
	 */
	public function countItems() {
		parent::countItems();
		
		return $this->photoList->countObjects();
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		$this->frame->assignVariables();
		WCF::getTPL()->assign(array(
			'allPhotos' => $this->allPhotos,
			'photos' => $this->photoList->getObjects(),
			'albumID' => $this->albumID,
			'album' => $this->album,
			'tagID' => $this->tagID,
			'tag' => $this->tag,
			'filterByAlbumID' => $this->filterByAlbumID,
			'filterByTagID' => $this->filterByTagID,
			'availableTags' => $this->tags,
			'availableAlbums' => UserGalleryAlbum::getAlbums($this->frame->getUserID()),
			'allowSpidersToIndexThisPage' => true
		));
	}
	
	/**
	 * @see SortablePage::validateSortField()
	 */
	public function validateSortField() {
		parent::validateSortField();
		
		switch ($this->sortField) {
			case 'albumID':
			case 'title':
			case 'filename':
			case 'fileExtension':
			case 'comments':
			case 'uploadTime': break;
			default: $this->sortField = $this->defaultSortField;
		}
	}
	
	/**
	 * @see Page::show()
	 */
	public function show() {
		// set active menu item
		UserProfileMenu::getInstance()->setActiveMenuItem('wcf.user.profile.menu.link.gallery');
		
		// check permission
		WCF::getUser()->checkPermission('user.gallery.canViewGallery');
		
		if (!MODULE_USER_GALLERY || !$this->frame->getUser()->getPermission('user.gallery.canUseGallery')) {
			throw new IllegalLinkException();
		}
		
		parent::show();
	}
}
?>