<?php
// wcf imports
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');
require_once(WCF_DIR.'lib/data/message/bbcode/URLBBCode.class.php');
require_once(WCF_DIR.'lib/data/message/bbcode/URLParser.class.php');

/**
 * Parses URLs to user gallery albums and photos.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	system.event.listener
 * @category 	Community Framework (commercial)
 */
class URLParserUserGalleryURLListener implements EventListener {
	protected $albums = array();
	protected $photos = array();
	protected $albumURLPattern = 'index\.php\?page=UserGalleryPhotos&albumID=([0-9]+)';
	protected $photoURLPattern = 'index\.php\?page=UserGalleryPhoto&photoID=([0-9]+)';
	
	/**
	 * @see EventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		if (!MODULE_USER_GALLERY || empty(URLParser::$text)) return;
		
		// reset data
		$this->albums = $this->photos = array();
		$albumIDArray = $photoIDArray = array();
		
		// get page urls
		$pageURLs = URLBBCode::getPageURLs();
		$pageURLs = '(?:'.implode('|', array_map('preg_quote', $pageURLs)).')';
		
		// build search pattern
		$albumIDPattern = "!\[url\](".$pageURLs."/?".$this->albumURLPattern.".*?)\[/url\]!i";
		$photoIDPattern = "!\[url\](".$pageURLs."/?".$this->photoURLPattern.".*?)\[/url\]!i";
		
		// find album ids
		if (preg_match_all($albumIDPattern, URLParser::$text, $matches)) {
			$albumIDArray = $matches[2];
		}
		
		// find photo ids
		if (preg_match_all($photoIDPattern, URLParser::$text, $matches)) {
			$photoIDArray = $matches[2];
		}
		
		// get albums
		if (count($albumIDArray) > 0) {
			// remove duplicates
			$albumIDArray = array_unique($albumIDArray);
				
			$sql = "SELECT	albumID, title
				FROM 	wcf".WCF_N."_user_gallery_album
				WHERE 	albumID IN (".implode(",", $albumIDArray).")";
			$result = WCF::getDB()->sendQuery($sql);
			while ($row = WCF::getDB()->fetchArray($result)) {
				$this->albums[$row['albumID']] = $row['title'];
			}
			
			if (count($this->albums) > 0) {
				// insert albums
				URLParser::$text = preg_replace_callback($albumIDPattern, array($this, 'buildAlbumURLTagCallback'), URLParser::$text);
			}
		}
		
		// get photos
		if (count($photoIDArray) > 0) {
			// remove duplicates
			$photoIDArray = array_unique($photoIDArray);
				
			$sql = "SELECT	photoID, title
				FROM 	wcf".WCF_N."_user_gallery
				WHERE 	photoID IN (".implode(",", $photoIDArray).")";
			$result = WCF::getDB()->sendQuery($sql);
			while ($row = WCF::getDB()->fetchArray($result)) {
				$this->photos[$row['photoID']] = $row['title'];
			}
			
			if (count($this->photos) > 0) {
				// insert albums
				URLParser::$text = preg_replace_callback($photoIDPattern, array($this, 'buildPhotoURLTagCallback'), URLParser::$text);
			}
		}
	}
	
	/**
	 * Builds the url bbcode tag.
	 * 
	 * @param	array		$matches
	 * @return	string
	 */
	private function buildAlbumURLTagCallback($matches) {
		$url = $matches[1];
		$albumID = $matches[2];
		
		if ($albumID != 0 && isset($this->albums[$albumID])) {
			return '[url=\''.$url.'\']'.$this->albums[$albumID].'[/url]';
		}
		
		return '[url]'.$url.'[/url]';
	}
	
	/**
	 * Builds the url bbcode tag.
	 * 
	 * @param	array		$matches
	 * @return	string
	 */
	private function buildPhotoURLTagCallback($matches) {
		$url = $matches[1];
		$photoID = $matches[2];
		
		if ($photoID != 0 && isset($this->photos[$photoID])) {
			return '[url=\''.$url.'\']'.$this->photos[$photoID].'[/url]';
		}
		
		return '[url]'.$url.'[/url]';
	}
}
?>