{include file="documentHeader"}
<head>
	<title>{lang}wcf.user.profile.title{/lang} - {lang}wcf.user.profile.members{/lang} - {lang}{PAGE_TITLE}{/lang}</title>
	{include file='headInclude' sandbox=false}
</head>
<body{if $templateName|isset} id="tpl{$templateName|ucfirst}"{/if}>
{* --- quick search controls --- *}
{assign var='searchFieldTitle' value='{lang}wcf.user.profile.search.query{/lang}'}
{capture assign=searchHiddenFields}
	<input type="hidden" name="userID" value="{@$user->userID}" />
{/capture}
{* --- end --- *}
{include file='header' sandbox=false}

<div id="main">
	{capture append='additionalMessages'}
		{if $errorField}
			<p class="error">{lang}wcf.global.form.error{/lang}</p>
		{/if}
		{if $success|isset}
			<p class="success">{lang}wcf.user.gallery.album.{@$action}.success{/lang}</p>
		{/if}
	{/capture}
	
	{include file="userProfileHeader"}
	
	<form method="post" action="index.php?form=UserGalleryAlbum{@$action|ucfirst}{if $albumID|isset}&amp;albumID={@$albumID}{/if}">
		<div class="border {if $this|method_exists:'getUserProfileMenu' && $this->getUserProfileMenu()->getMenuItems('')|count > 1}tabMenuContent{else}content{/if}">
			<div class="container-1 gallery">
				<h3 class="subHeadline">{lang}wcf.user.gallery.album.{@$action}{/lang}</h3>
				
				<div class="contentHeader">
					<div class="largeButtons">
						<ul>
							<li><a href="index.php?page=UserGalleryAlbumList&amp;userID={@$userID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.albums.allAlbums{/lang}"><img src="{icon}galleryAlbumsM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.albums.allAlbums{/lang}</span></a></li>
							<li><a href="index.php?page=UserGalleryPhotos&amp;userID={@$userID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photos.allPhotos{/lang}"><img src="{icon}galleryPhotosM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photos.allPhotos{/lang}</span></a></li>
							{if $additionalLargeButtons|isset}{@$additionalLargeButtons}{/if}
						</ul>
					</div>
				</div>
				
				<fieldset>
					<legend>{lang}wcf.user.gallery.album{/lang}</legend>

					{if $action == 'add'}<p>{lang}wcf.user.gallery.album.add.description{/lang}</p>{/if}

					<div class="formElement{if $errorField == 'title'} formError{/if}">
						<div class="formFieldLabel">
							<label for="title">{lang}wcf.user.gallery.album.title{/lang}</label>
						</div>
						<div class="formField">
							<input type="text" class="inputText" id="title" name="title" value="{$title}" />
							{if $errorField == 'title'}
								<p class="innerError">
									{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
								</p>
							{/if}
						</div>
					</div>
					
					<div class="formElement">
						<div class="formFieldLabel">
							<label for="description">{lang}wcf.user.gallery.album.description{/lang}</label>
						</div>
						<div class="formField">
							<textarea name="description" id="description" rows="10" cols="40">{$description}</textarea> 
						</div>
					</div>
					
					{if $action == 'edit' && $availableCovers|count > 0}
						<div class="formElement{if $errorField == 'coverPhotoID'} formError{/if}">
							<div class="formFieldLabel">
								<label for="coverPhotoID">{lang}wcf.user.gallery.album.cover{/lang}</label>
							</div>
							<div class="formField">
								<select name="coverPhotoID" id="coverPhotoID">
									{htmlOptions options=$availableCovers selected=$coverPhotoID}
								</select>
								{if $errorField == 'coverPhotoID'}
									<p class="innerError">
										{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
									</p>
								{/if}
							</div>
						</div>
					{/if}
					
					{if $additionalFields|isset}{@$additionalFields}{/if}
				</fieldset>
			</div>
		</div>
		
		<div class="formSubmit">
			{@SID_INPUT_TAG}
			<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" />
			<input type="reset" accesskey="r" value="{lang}wcf.global.button.reset{/lang}" />
		</div>
	</form>
</div>

{include file='footer' sandbox=false}
</body>
</html>