{include file="documentHeader"}
<head>
	<title>{lang}wcf.user.profile.title{/lang} - {lang}wcf.user.profile.members{/lang} - {lang}{PAGE_TITLE}{/lang}</title>
	{include file='headInclude' sandbox=false}
</head>
<body{if $templateName|isset} id="tpl{$templateName|ucfirst}"{/if}>
{* --- quick search controls --- *}
{assign var='searchFieldTitle' value='{lang}wcf.user.profile.search.query{/lang}'}
{capture assign=searchHiddenFields}
	<input type="hidden" name="userID" value="{@$user->userID}" />
{/capture}
{* --- end --- *}
{include file='header' sandbox=false}

<div id="main">
	{capture append='additionalMessages'}
		{if $errorField}
			<p class="error">{lang}wcf.global.form.error{/lang}</p>
		{/if}
		{if $success|isset}
			<p class="success">{lang}wcf.user.gallery.photo.{@$action}.success{/lang}</p>
			
			{if $action == 'add'}
				{assign var=warnings value=''}
				{foreach from=$photos item=photo}
					{if !$photo->hasQuadraticThumbnail}
						{capture append=warnings}<p>{lang}wcf.user.gallery.photo.warning.missingThumbnails{/lang}</p>{/capture}
					{/if}
				{/foreach}
				{if $warnings != ''}
					<div class="warning">{@$warnings}</div>
				{/if}
			{/if}
		{/if}
	{/capture}
	
	{include file="userProfileHeader"}
	
	<form method="post" enctype="multipart/form-data" action="index.php?form=UserGalleryPhoto{@$action|ucfirst}{if $photoID|isset}&amp;photoID={@$photoID}{/if}">
		<div class="border {if $this|method_exists:'getUserProfileMenu' && $this->getUserProfileMenu()->getMenuItems('')|count > 1}tabMenuContent{else}content{/if}">
			<div class="container-1 gallery">
				<h3 class="subHeadline">{lang}wcf.user.gallery.photo.{@$action}{/lang}</h3>
				
				<div class="contentHeader">
					<div class="largeButtons">
						<ul>
							<li><a href="index.php?page=UserGalleryPhotos&amp;userID={@$userID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photos.allPhotos{/lang}"><img src="{icon}galleryPhotosM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photos.allPhotos{/lang}</span></a></li>
							<li><a href="index.php?page=UserGalleryAlbumList&amp;userID={@$userID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.albums{/lang}"><img src="{icon}galleryAlbumsM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.albums.allAlbums{/lang}</span></a></li>
							{if $additionalLargeButtons|isset}{@$additionalLargeButtons}{/if}
						</ul>
					</div>
				</div>
				
				<fieldset{if $errorField == 'upload'} class="formError"{/if}>
					<legend>{lang}wcf.user.gallery.photo{if $action == 'add'}.upload{/if}{/lang}</legend>
					{if $action == 'add'}
						<ol id="uploadFields" class="itemList">
							<li>
								<div class="buttons">
									<a href="#delete" title="{lang}wcf.global.button.delete{/lang}" class="hidden"><img src="{icon}deleteS.png{/icon}" longdesc="" alt="" /></a>
								</div>
								<div class="itemListTitle">
									<input type="file" size="50" name="upload[]" tabindex="{counter name='tabindex'}" />
								</div>
							</li>
						</ol>
						
						{if $errorField == 'upload'}
							<div class="innerError">
								{if $errorType|is_array}
									{foreach from=$errorType item=error}
										<p>
											{if $error.errorType == 'illegalExtension'}{lang}wcf.user.gallery.photo.upload.error.illegalExtension{/lang}{/if}
											{if $error.errorType == 'tooLarge'}{lang}wcf.user.gallery.photo.upload.error.tooLarge{/lang}{/if}
											{if $error.errorType == 'badImage'}{lang}wcf.user.gallery.photo.upload.error.badImage{/lang}{/if}
											{if $error.errorType == 'tooManyPhotos'}{lang}wcf.user.gallery.photo.upload.error.tooManyPhotos{/lang}{/if}
											{if $error.errorType == 'quotaFull'}{lang}wcf.user.gallery.photo.upload.error.quotaFull{/lang}{/if}
											{if $error.errorType == 'copyFailed'}{lang}wcf.user.gallery.photo.upload.error.copyFailed{/lang}{/if}
										</p>
									{/foreach}
								{elseif $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
							</div>
						{/if}
						
						<div class="formFieldDesc">
							<p>{lang}wcf.user.gallery.photo.upload.description{/lang}</p>
						</div>
				
						<script type="text/javascript">
						//<![CDATA[
							var openUploads = {@$freePhotos} - 1;
							function addUploadField() {
								if (openUploads > 0) {
									var fileInput = new Element('input', { 'type': 'file', 'name': 'upload[]', 'size': 50, 'tabindex': {counter name='tabindex'} });
									var fileDiv = new Element('div').addClassName('itemListTitle');
									var deleteButton = new Element('a', { 'href': '#delete', 'title': '{lang}wcf.global.button.delete{/lang}' });
									deleteButton.addClassName('hidden');
									var deleteImg = new Element('img', { 'src': '{icon}deleteS.png{/icon}', 'longdesc': '' });
									var buttons = new Element('div').addClassName('buttons').insert(deleteButton.insert(deleteImg));
									
									$('uploadFields').insert(new Element('li').insert(buttons).insert(fileDiv.insert(fileInput)));
									deleteButton.observe('click', removeUploadField);
									fileInput.observe('change', uploadFieldChanged);
									openUploads--;
									fileInput.focus();
								}
							}
							
							function removeUploadField(evt) {
								var fileInput = evt.findElement().up('li').down('input');
								var emptyField = true;
								var counter = 0;
								$$('#uploadFields input[type=file]').each(function(input) { 
									if (input.value == '') {
										emptyField = true;
									}
									counter++;
								});
								if (emptyField && fileInput.value != '' && counter > 1) {
									fileInput.up('li').fade({ 
										'duration': '0.5', afterFinish: function() { fileInput.up('li').remove(); } 
									});
									openUploads++;
								}
								else {
									fileInput.value = '';
								}
								evt.stop();
							}
							
							function uploadFieldChanged(e) {
								if (!e) e = window.event;
									
								if (e.target) var inputField = e.target;
								else if (e.srcElement) var inputField = e.srcElement;
								
								var emptyField = false;
								$$('#uploadFields input[type=file]').each(function(input) {
									if (input.value == '') emptyField = true;
								});
								
								if (!emptyField && inputField.value != '' && inputField.value != inputField.oldValue) {
									inputField.oldValue = inputField.value;
									addUploadField();
								}
								if (inputField.value == '') {
									$(inputField).up('li').down('a[href*="#delete"]').addClassName('hidden');	
								}
								else {
									$(inputField).up('li').down('a[href*="#delete"]').removeClassName('hidden');	
								}
							}
							
							// add button
							document.observe('dom:loaded', function() { 
								$$('#uploadFields input[type=file]').invoke('observe', 'change', uploadFieldChanged);
								$$('#uploadFields a[href*="#delete"]').invoke('observe', 'click', removeUploadField);
							});
							//]]>
						</script>
					{else}
						<div class="formElement">
							<div class="formFieldLabel">
								<label for="upload">{lang}wcf.user.gallery.photo{/lang}</label>
							</div>
							<div class="formField galleryPhotoEdit" title="{$photo->title}">
								<img src="{$photo->getPhoto('small')}" alt="" />
							</div>
						</div>
					{/if}
				</fieldset>
			
				<fieldset>
					<legend>{lang}wcf.user.gallery.photo.meta{/lang}</legend>
					{if $action == 'add'}<p class="formFieldDesc">{lang}wcf.user.gallery.photo.meta.description{/lang}</p>{/if}
					{if $availableAlbums|count > 0}
						<div class="formElement">
							<div class="formFieldLabel">
								<label for="albumID">{lang}wcf.user.gallery.album{/lang}</label>
							</div>
							<div class="formField">
								<select name="albumID" id="albumID" tabindex="{counter name='tabindex'}">
									<option value="0"></option>
									{htmlOptions options=$availableAlbums selected=$albumID}
								</select>
							</div>
						</div>
					{/if}
		
					<div class="formElement{if $errorField == 'title'} formError{/if}">
						<div class="formFieldLabel">
							<label for="title">{lang}wcf.user.gallery.photo.title{/lang}</label>
						</div>
						<div class="formField">
							<input type="text" class="inputText" id="title" name="title" value="{$title}" tabindex="{counter name='tabindex'}" />
							{if $errorField == 'title'}
								<p class="innerError">
									{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
								</p>
							{/if}
						</div>
						{if $action == 'add'}<p class="formFieldDesc">{lang}wcf.user.gallery.photo.title.description{/lang}</p>{/if}
					</div>
					
					{if MODULE_TAGGING == 1}{include file='tagAddBit'}{/if}
					
					<div class="formElement">
						<div class="formFieldLabel">
							<label for="description">{lang}wcf.user.gallery.photo.description{/lang}</label>
						</div>
						<div class="formField">
							<textarea name="description" id="description" rows="10" cols="40" tabindex="{counter name='tabindex'}">{$description}</textarea> 
						</div>
					</div>
					
					{if $additionalFields|isset}{@$additionalFields}{/if}
				</fieldset>
			</div>	
		</div>
		
		<div class="formSubmit">
			{@SID_INPUT_TAG}
			<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" tabindex="{counter name='tabindex'}" />
			<input type="reset" accesskey="r" value="{lang}wcf.global.button.reset{/lang}" tabindex="{counter name='tabindex'}" />
		</div>
	</form>
</div>

{include file='footer' sandbox=false}
</body>
</html>