{include file="documentHeader"}
<head>
	<title>{lang}wcf.user.profile.title{/lang} - {lang}wcf.user.profile.members{/lang} - {lang}{PAGE_TITLE}{/lang}</title>
	{include file='headInclude' sandbox=false}
	{include file='userGallerySlideShow'}
	<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/MultiPagesLinks.class.js"></script>
</head>
<body{if $templateName|isset} id="tpl{$templateName|ucfirst}"{/if}>
{* --- quick search controls --- *}
{assign var='searchFieldTitle' value='{lang}wcf.user.profile.search.query{/lang}'}
{capture assign=searchHiddenFields}
	<input type="hidden" name="userID" value="{@$user->userID}" />
{/capture}
{* --- end --- *}
{include file='header' sandbox=false}

<div id="main">
	{include file="userProfileHeader"}
	
	<div class="border">
		<div class="layout{if $album}-3{else}-1{/if}">
			<div class="columnContainer">
				{if $album}
					<div class="container-3 column first gallerySidebar">
						<div class="columnInner">
							<div class="contentBox">
								<h3 class="subHeadline">{lang}wcf.user.gallery.album{/lang}: {$album->title}</h3>
								<p class="lastUpdate smallFont">{lang}wcf.user.gallery.album.lastUpdate{/lang}: {@$album->lastUpdateTime|time}</p>
								<div class="galleryAlbumCover"><img src="{$album->getCoverPhoto()->getPhoto('small')}" alt="" title="{lang}wcf.user.gallery.album.cover.image{/lang}" /></div>
								<p class="description">{@$album->getFormattedDescription()}</p>
								{if $album->isEditable() || $album->isDeletable() || $additionalAlbumSmallButtons|isset}
									<div class="buttonBar">
										<div class="smallButtons">
											<ul>
												{if $album->isEditable()}<li><a href="index.php?form=UserGalleryAlbumEdit&amp;albumID={@$album->albumID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.album.edit{/lang}"><img src="{icon}editS.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.album.edit{/lang}</span></a></li>{/if}
												{if $album->isDeletable()}<li><a href="index.php?action=UserGalleryAlbumDelete&amp;albumID={@$album->albumID}&amp;t={@SECURITY_TOKEN}{@SID_ARG_2ND}" onclick="return confirm('{lang}wcf.user.gallery.album.delete.sure{/lang}')" title="{lang}wcf.user.gallery.album.delete{/lang}"><img src="{icon}deleteS.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.album.delete{/lang}</span></a></li>{/if}
												{if $additionalAlbumSmallButtons|isset}{@$additionalAlbumSmallButtons}{/if}
											</ul>
										</div>
									</div>
								{/if}
							</div>
						</div>
					</div>
				{/if}
				<div class="container-1 column {if $album}second{else}first{/if}">
					<div class="columnInner">
						{if $photos|count > 0}
							<div class="contentBox">
								<h3 class="subHeadline">{if $albumID}{lang}wcf.user.gallery.photos{/lang}{elseif $tagID}{lang}wcf.user.gallery.photos.tagged{/lang}{else}{lang}wcf.user.gallery.photos{/lang}{/if} <span>({#$items})</span></h3>
								
								<div class="contentHeader">
									{if $albumID}
										{pages print=true assign=pagesOutput link="index.php?page=UserGalleryPhotos&albumID=$albumID&pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"|concat:SID_ARG_2ND_NOT_ENCODED}
									{elseif $tagID}
										{pages print=true assign=pagesOutput link="index.php?page=UserGalleryPhotos&userID=$userID&tagID=$tagID&pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"|concat:SID_ARG_2ND_NOT_ENCODED}
									{else}
										{pages print=true assign=pagesOutput link="index.php?page=UserGalleryPhotos&userID=$userID&pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"|concat:SID_ARG_2ND_NOT_ENCODED}
									{/if}
								</div>
								<ul class="galleryIndex floatContainer">
									{foreach from=$photos item=photo}
										<li class="floatedElement container-4 deletable">
											<a href="index.php?page=UserGalleryPhoto&amp;photoID={@$photo->photoID}{@SID_ARG_2ND}#profileContent" title="{$photo->title}">
												<span class="thumbnail" style="width: {@$photo->getTinyWidth()}px;"><img src="{$photo->getPhoto('tiny')}" alt="" /></span>
												<span class="caption">{$photo->title}</span>
											</a>
											<p class="smallFont light">{lang}wcf.user.gallery.photo.numberOfComments{/lang}</p>
											{if $photo->isDeletable() || $photo->isEditable() || $additionalPhotoButtons[$photo->photoID]|isset}
												<div class="thumbnailButtons">
													{if $photo->isDeletable()}<a href="index.php?action=UserGalleryPhotoDelete&amp;photoID={@$photo->photoID}&amp;t={@SECURITY_TOKEN}{@SID_ARG_2ND}" title="{lang}wcf.user.gallery.photo.delete{/lang}" class="deleteButton"><img src="{icon}deleteS.png{/icon}" alt="" longdesc="{lang}wcf.user.gallery.photo.delete.sure{/lang}" /></a>{/if}
													{if $photo->isEditable()}<a href="index.php?form=UserGalleryPhotoEdit&amp;photoID={@$photo->photoID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photo.edit{/lang}"><img src="{icon}editS.png{/icon}" alt="" /></a>{/if}
													{if $album && $album->isEditable() && $album->coverPhotoID != $photo->photoID}<a href="index.php?action=UserGalleryAlbumCoverSet&amp;albumID={@$album->albumID}&amp;photoID={@$photo->photoID}&amp;t={@SECURITY_TOKEN}{@SID_ARG_2ND}" title="{lang}wcf.user.gallery.album.cover.set{/lang}"><img src="{icon}defaultS.png{/icon}" alt="" /></a>{/if}
													{if $additionalPhotoButtons[$photo->photoID]|isset}{@$additionalPhotoButtons[$photo->photoID]}{/if}
												</div>
											{/if}
										</li>
									{/foreach}
								</ul>
							
								<div class="contentFooter">
									{@$pagesOutput}
									
									<div class="largeButtons">
										<ul>
											<li><a id="startSlideShow" href="#startSlideShow" title="{lang}wcf.user.gallery.photo.slideShow{/lang}"><img src="{icon}slideShowM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photo.slideShow{/lang}</span></a></li>
											{if $tag || $album}<li><a href="index.php?page=UserGalleryPhotos&amp;userID={@$user->userID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photos.allPhotos{/lang}"><img src="{icon}galleryPhotosM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photos.allPhotos{/lang}</span></a></li>{/if}
											{if $this->user->userID == $user->userID && $this->user->getPermission('user.gallery.canUseGallery')}<li><a href="index.php?form=UserGalleryPhotoAdd{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photo.add{/lang}"><img src="{icon}galleryPhotoAddM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photo.add{/lang}</span></a></li>{/if}
											
											{if $additionalLargeButtons|isset}{@$additionalLargeButtons}{/if}
										</ul>
									</div>
								</div>
								
								<div class="buttonBar">
									<div class="smallButtons">
										<ul>
											<li class="extraButton"><a href="#top" title="{lang}wcf.global.scrollUp{/lang}"><img src="{icon}upS.png{/icon}" alt="{lang}wcf.global.scrollUp{/lang}" /> <span class="hidden">{lang}wcf.global.scrollUp{/lang}</span></a></li>
											
											{if $additionalPhotoSmallButtons|isset}{@$additionalPhotoSmallButtons}{/if}
										</ul>
									</div>
								</div>
							</div>
						{else}
							<div class="contentBox">
								<h3 class="subHeadline">{if $albumID}{$album->title}{elseif $tagID}{lang}wcf.user.gallery.photos.tagged{/lang}{else}{lang}wcf.user.gallery.photos{/lang}{/if} <span>({#$items})</span></h3>
								<p>{lang}wcf.user.gallery.photo.noPhotos{/lang}</p>
								
								<div class="contentFooter">
									<div class="largeButtons">
										<ul>
											{if $tag || $album}<li><a href="index.php?page=UserGalleryPhotos&amp;userID={@$user->userID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photos.allPhotos{/lang}"><img src="{icon}galleryPhotosM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photos.allPhotos{/lang}</span></a></li>{/if}
											{if $this->user->userID == $user->userID && $this->user->getPermission('user.gallery.canUseGallery')}<li><a href="index.php?form=UserGalleryPhotoAdd{if $albumID}&amp;albumID={@$albumID}{/if}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photo.add{/lang}"><img src="{icon}galleryPhotoAddM.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photo.add{/lang}</span></a></li>{/if}
											
											{if $additionalPhotoLargeButtons|isset}{@$additionalPhotoLargeButtons}{/if}
										</ul>
									</div>
								</div>
								
								<div class="buttonBar">
									<div class="smallButtons">
										<ul>
											<li class="extraButton"><a href="#top" title="{lang}wcf.global.scrollUp{/lang}"><img src="{icon}upS.png{/icon}" alt="{lang}wcf.global.scrollUp{/lang}" /> <span class="hidden">{lang}wcf.global.scrollUp{/lang}</span></a></li>
											
											{if $additionalPhotoSmallButtons|isset}{@$additionalPhotoSmallButtons}{/if}
										</ul>
									</div>
								</div>
							</div>
						{/if}
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="border infoBox">
		<div class="{cycle values='container-1,container-2'}">
			<div class="containerIcon">
				<img src="{icon}sortM.png{/icon}" alt="" />
			</div>

			<div class="containerContent">
				<h3>{lang}wcf.user.gallery.sort{/lang}</h3>
				<form method="get" action="index.php">
				<div class="floatContainer">
					<input type="hidden" name="page" value="UserGalleryPhotos" />
					{if $albumID}<input type="hidden" name="albumID" value="{@$albumID}" />{/if}
					<input type="hidden" name="userID" value="{@$userID}" />
					{if $tagID}<input type="hidden" name="tagID" value="{@$tagID}" />{/if}
					<input type="hidden" name="pageNo" value="{@$pageNo}" />
														
					<div class="floatedElement">
						<label for="sortField">{lang}wcf.user.gallery.sort{/lang}</label>
						<select name="sortField" id="sortField">
							<option value="albumID"{if $sortField == 'albumID'} selected="selected"{/if}>{lang}wcf.user.gallery.album{/lang}</option>
							<option value="title"{if $sortField == 'title'} selected="selected"{/if}>{lang}wcf.user.gallery.photo.title{/lang}</option>
							<option value="filename"{if $sortField == 'filename'} selected="selected"{/if}>{lang}wcf.user.gallery.photo.filename{/lang}</option>
							<option value="uploadTime"{if $sortField == 'uploadTime'} selected="selected"{/if}>{lang}wcf.user.gallery.photo.uploadTime{/lang}</option>
							{if $additionalSortFields|isset}{@$additionalSortFields}{/if}
						</select>

						<select name="sortOrder" id="sortOrder">
							<option value="ASC"{if $sortOrder == 'ASC'} selected="selected"{/if}>{lang}wcf.global.sortOrder.ascending{/lang}</option>
							<option value="DESC"{if $sortOrder == 'DESC'} selected="selected"{/if}>{lang}wcf.global.sortOrder.descending{/lang}</option>
						</select>
					</div>
					
					<div class="floatedElement">
						<input type="image" class="inputImage" src="{icon}submitS.png{/icon}" alt="{lang}wcf.global.button.submit{/lang}" />
					</div>

					{@SID_INPUT_TAG}
				</div>
				</form>
			</div>
		</div>
		{if $availableAlbums|count > 0}
			<div class="{cycle values='container-1,container-2'}">
				<div class="containerIcon">
					<img src="{icon}galleryAlbumsM.png{/icon}" alt="" />
				</div>
				<div class="containerContent">
					<h3><span>{lang}wcf.user.gallery.albums{/lang}</span></h3>
					<p>{implode from=$availableAlbums item=album}<a href="index.php?page=UserGalleryPhotos&amp;albumID={@$album->albumID}{@SID_ARG_2ND}#profileContent">{$album->title}</a>{/implode}</p>						
				</div>
			</div>
		{/if}
		
		{if $availableTags|count > 0}
			<div class="{cycle values='container-1,container-2'}">
				<div class="containerIcon">
					<img src="{icon}tagM.png{/icon}" alt="" />
				</div>
				<div class="containerContent">
					<h3><span>{lang}wcf.tagging.filter{/lang}</span></h3>
					<ul class="tagCloud">
						{foreach from=$availableTags item=tag}
						<li><a href="index.php?page=UserGalleryPhotos&amp;userID={@$userID}&amp;tagID={@$tag->getID()}{@SID_ARG_2ND}#profileContent" style="font-size: {@$tag->getSize()}%">{$tag->getName()}</a></li>
						{/foreach}
					</ul>
				</div>
			</div>
		{/if}
	</div>

</div>

{include file='footer' sandbox=false}
</body>
</html>