<?php
// wcf imports
require_once(WCF_DIR.'lib/form/UserGalleryAlbumAddForm.class.php');

/**
 * Shows the form for editing gallery albums.
 * 
 * @author 	Marcel Werk
 * @copyright	2001-2009 WoltLab GmbH
 * @license	WoltLab Burning Board License <http://www.woltlab.com/products/burning_board/license.php>
 * @package	com.woltlab.wcf.user.gallery
 * @subpackage	form
 * @category 	Community Framework (commercial)
 */
class UserGalleryAlbumEditForm extends UserGalleryAlbumAddForm {
	/**
	 * album id
	 * @var	integer
	 */
	public $albumID = 0;
	
	/**
	 * album editor object
	 * @var	UserGalleryAlbumEditor
	 */
	public $album = null;
	
	/**
	 * list of album photos
	 * @var array<UserGalleryPhoto>
	 */
	public $availableCovers = null;
	
	// form parameters
	public $coverPhotoID = 0;
	
	/**
	 * @see	Page::readParameters()
	 */
	public function readParameters() {
		AbstractForm::readParameters();
		
		if (isset($_REQUEST['albumID'])) $this->albumID = intval($_REQUEST['albumID']);
		$this->album = new UserGalleryAlbumEditor($this->albumID);
		if (!$this->album->albumID) {
			throw new IllegalLinkException();
		}
		if (!$this->album->isEditable()) {
			throw new PermissionDeniedException();
		}
		
		// get profile frame
		$this->frame = new UserProfileFrame($this, $this->album->ownerID);
		
		// get available photos for the album cover
		$this->availableCovers = $this->album->getPhotos();
	}
	
	/**
	 * @see	Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
		
		if (isset($_POST['coverPhotoID'])) $this->coverPhotoID = intval($_POST['coverPhotoID']);
	}
	
	/**
	 * @see	Form::validate()
	 */
	public function validate() {
		parent::validate();
		
		if (count($this->availableCovers) && !$this->coverPhotoID) {
			throw new UserInputException('coverPhotoID');
		}
		if ($this->coverPhotoID && !isset($this->availableCovers[$this->coverPhotoID])) {
			throw new UserInputException('coverPhotoID');
		}
	}
	
	/**
	 * @see	Form::save()
	 */
	public function save() {
		AbstractForm::save();
		
		// update
		$this->album->update($this->title, $this->description, $this->coverPhotoID);
		$this->saved();
		
		// show success message
		WCF::getTPL()->assign('success', true);
	}
	
	/**
	 * @see Page::readData()
	 */
	public function readData() {
		parent::readData();
		
		if (!count($_POST)) {
			$this->title = $this->album->title;
			$this->description = $this->album->description;
			$this->coverPhotoID = $this->album->coverPhotoID;
		}
	}
	
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign(array(
			'action' => 'edit',
			'albumID' => $this->albumID,
			'availableCovers' => $this->availableCovers,
			'coverPhotoID' => $this->coverPhotoID
		));
	}
}
?>