{include file="documentHeader"}
<head>
	<title>{lang}wcf.user.profile.title{/lang} - {lang}wcf.user.profile.members{/lang} - {lang}{PAGE_TITLE}{/lang}</title>
	{include file='headInclude' sandbox=false}
	{include file='imageViewer'}
	<script type="text/javascript" src="{@RELATIVE_WCF_DIR}js/MultiPagesLinks.class.js"></script>
</head>
<body{if $templateName|isset} id="tpl{$templateName|ucfirst}"{/if}>
{* --- quick search controls --- *}
{assign var='searchFieldTitle' value='{lang}wcf.user.profile.search.query{/lang}'}
{capture assign=searchHiddenFields}
	<input type="hidden" name="userID" value="{@$user->userID}" />
{/capture}
{* --- end --- *}
{include file='header' sandbox=false}

<div id="main">
	{capture append='additionalMessages'}
		{if !$errorField|empty}
			<p class="error">{lang}wcf.global.form.error{/lang}</p>
		{/if}
	{/capture}
	
	{include file="userProfileHeader"}
	
	<div class="border">
		<div class="layout-2">
			<div class="columnContainer">
				<div class="container-1 column first">
					<div class="columnInner">
						<div class="contentBox">
							<h3 class="subHeadline">{$photo->title}</h3>
							
							<div class="galleryPhoto"><a href="{if $photo->hasLargeThumbnail}{$photo->getPhoto('large')}{else}{$photo->getPhoto()}{/if}" class="enlargable" title="{$photo->title}"><img src="{$photo->getPhoto($size)}" style="max-width: {@$photo->getPhotoWidth($size)}px; max-height: {@$photo->getPhotoHeight($size)}px" alt="" /></a></div>
							{if $photo->description}<p class="galleryPhotoCaption">{@$photo->getFormattedDescription()}</p>{/if}
						
							<div class="buttonBar">
								<div class="smallButtons">
									<ul>
										<li class="extraButton"><a href="#top" title="{lang}wcf.global.scrollUp{/lang}"><img src="{icon}upS.png{/icon}" alt="{lang}wcf.global.scrollUp{/lang}" /> <span class="hidden">{lang}wcf.global.scrollUp{/lang}</span></a></li>
										<li class="hidden options" id="photoZoomButton"><a id="photoZoom" title="{lang}wcf.user.gallery.photo.zoom{/lang}"><img src="{icon}allSizesS.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photo.zoom{/lang}</span></a>
											<div class="hidden" id="photoZoomMenu">
												<div class="pageMenu">
													<ul>
														{if $photo->hasQuadraticThumbnail}
															<li><a href="{$photo->getPhoto('quadratic')}">{lang}wcf.user.gallery.photo.size.quadratic{/lang} ({@$photo->getQuadraticWidth()}x{@$photo->getQuadraticHeight()})</a></li>
														{/if}
														{if $photo->hasTinyThumbnail}
															<li><a href="{$photo->getPhoto('tiny')}">{lang}wcf.user.gallery.photo.size.tiny{/lang} ({@$photo->getTinyWidth()}x{@$photo->getTinyHeight()})</a></li>
														{/if}
														{if $photo->hasSmallThumbnail}
															<li><a href="{$photo->getPhoto('small')}">{lang}wcf.user.gallery.photo.size.small{/lang} ({@$photo->getSmallWidth()}x{@$photo->getSmallHeight()})</a></li>
														{/if}
														{if $photo->hasMediumThumbnail}
															<li><a href="{$photo->getPhoto('medium')}">{lang}wcf.user.gallery.photo.size.medium{/lang} ({@$photo->getMediumWidth()}x{@$photo->getMediumHeight()})</a></li>
														{/if}
														{if $photo->hasLargeThumbnail}
															<li><a href="{$photo->getPhoto('large')}">{lang}wcf.user.gallery.photo.size.large{/lang} ({@$photo->getLargeWidth()}x{@$photo->getLargeHeight()})</a></li>
														{/if}
														<li><a href="{$photo->getPhoto()}"{if !$photo->hasLargeThumbnail}{/if}>{lang}wcf.user.gallery.photo.size.original{/lang} ({@$photo->width}x{@$photo->height})</a></li>
													</ul>
												</div>
											</div>
										</li>
										{if $photo->isEditable()}<li><a href="index.php?form=UserGalleryPhotoEdit&amp;photoID={@$photo->photoID}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photo.edit{/lang}"><img src="{icon}editS.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photo.edit{/lang}</span></a></li>{/if}
										{if $photo->isDeletable()}<li><a href="index.php?action=UserGalleryPhotoDelete&amp;photoID={@$photo->photoID}&amp;t={@SECURITY_TOKEN}{@SID_ARG_2ND}" onclick="return confirm('{lang}wcf.user.gallery.photo.delete.sure{/lang}')" title="{lang}wcf.user.gallery.photo.delete{/lang}"><img src="{icon}deleteS.png{/icon}" alt="" /> <span>{lang}wcf.user.gallery.photo.delete{/lang}</span></a></li>{/if}
										{if MODULE_USER_INFRACTION == 1 && $this->user->getPermission('admin.user.infraction.canWarnUser')}
											<li><a href="index.php?form=UserWarn&amp;userID={@$photo->ownerID}&amp;objectType=userGalleryPhoto&amp;objectID={@$photo->photoID}{@SID_ARG_2ND}" title="{lang}wcf.user.infraction.button.warn{/lang}"><img src="{icon}infractionWarningS.png{/icon}" alt="" /> <span>{lang}wcf.user.infraction.button.warn{/lang}</span></a></li>
										{/if}
										
										{if $additionalSmallButtons|isset}{@$additionalSmallButtons}{/if}
									</ul>
									<script type="text/javascript">
										//<![CDATA[
										$('photoZoomButton').removeClassName('hidden');
										popupMenuList.register("photoZoom");
										//]]>
									</script>
								</div>
							</div>
						</div>
					
						{if $comments|count > 0}
							{if $photo->isCommentable()}{assign var=commentUsername value=$username}{/if}
							<a id="comments"></a>
							<div class="contentBox">
								<h3 class="subHeadline">{lang}wcf.user.gallery.photo.comments{/lang} <span>({#$items})</span></h3>
								
								<div class="contentHeader">
									{pages print=true assign=pagesOutput link="index.php?page=UserGalleryPhoto&photoID=$photoID&size=$size&view=$view&pageNo=%d"|concat:SID_ARG_2ND_NOT_ENCODED}
								</div>
								
								<ul class="dataList messages">
									{assign var='messageNumber' value=$items-$startIndex+1}
									{foreach from=$comments item=commentObj}
										<li class="{cycle values='container-1,container-2'}">
											<a id="comment{@$commentObj->commentID}"></a>
											<div class="containerIcon">
												{if $commentObj->getUser()->getAvatar()}
													{assign var=x value=$commentObj->getUser()->getAvatar()->setMaxSize(24, 24)}
													{if $commentObj->userID}<a href="index.php?page=User&amp;userID={@$commentObj->userID}{@SID_ARG_2ND}" title="{lang username=$commentObj->username}wcf.user.viewProfile{/lang}">{/if}{@$commentObj->getUser()->getAvatar()}{if $commentObj->userID}</a>{/if}
												{else}
													{if $commentObj->userID}<a href="index.php?page=User&amp;userID={@$commentObj->userID}{@SID_ARG_2ND}" title="{lang username=$commentObj->username}wcf.user.viewProfile{/lang}">{/if}<img src="{@RELATIVE_WCF_DIR}images/avatars/avatar-default.png" alt="" style="width: 24px; height: 24px" />{if $commentObj->userID}</a>{/if}
												{/if}
											</div>
											<div class="containerContent">
												{if $action == 'edit' && $commentID == $commentObj->commentID}
													<form method="post" action="index.php?page=UserGalleryPhoto&amp;photoID={@$photoID}&amp;commentID={@$commentObj->commentID}&amp;action=edit">
														<div{if $errorField == 'comment'} class="formError"{/if}>
															<textarea name="comment" id="comment" rows="10" cols="40">{$comment}</textarea>
															{if $errorField == 'comment'}
																<p class="innerError">
																	{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
																	{if $errorType == 'tooLong'}{lang}wcf.user.gallery.photo.comment.error.tooLong{/lang}{/if}
																</p>
															{/if}
														</div>
														<div class="formSubmit">
															<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" />
															<input type="reset" accesskey="r" value="{lang}wcf.global.button.reset{/lang}" />
															
															{@SID_INPUT_TAG}
														</div>
													</form>
												{else}
													<div class="buttons">
														{if $commentObj->isEditable()}<a href="index.php?page=UserGalleryPhoto&amp;photoID={@$photoID}&amp;commentID={@$commentObj->commentID}&amp;action=edit{@SID_ARG_2ND}#comment{@$commentObj->commentID}" title="{lang}wcf.user.gallery.photo.comment.edit{/lang}"><img src="{icon}editS.png{/icon}" alt="" /></a>{/if}
														{if $commentObj->isDeletable()}<a href="index.php?action=UserGalleryPhotoCommentDelete&amp;commentID={@$commentObj->commentID}&amp;t={@SECURITY_TOKEN}{@SID_ARG_2ND}#comments" onclick="return confirm('{lang}wcf.user.gallery.photo.comment.delete.sure{/lang}')" title="{lang}wcf.user.gallery.photo.comment.delete{/lang}"><img src="{icon}deleteS.png{/icon}" alt="" /></a>{/if}
														<a href="index.php?page=UserGalleryPhoto&amp;photoID={@$photoID}&amp;commentID={@$commentObj->commentID}{@SID_ARG_2ND}#comment{@$commentObj->commentID}" title="{lang}wcf.user.gallery.photo.comment.permalink{/lang}">#{#$messageNumber}</a>
													</div>
													<p class="firstPost smallFont light">{lang}wcf.user.gallery.photo.comment.by{/lang} {if $commentObj->userID}<a href="index.php?page=User&amp;userID={@$commentObj->userID}{@SID_ARG_2ND}">{$commentObj->username}</a>{else}{$commentObj->username}{/if} ({@$commentObj->time|time})</p>
													<p>{@$commentObj->getFormattedComment()}</p>
												{/if}
											</div>
										</li>
										{assign var='messageNumber' value=$messageNumber-1}
									{/foreach}
								</ul>
								
								<div class="contentFooter">
									{@$pagesOutput}
								</div>
								
								<div class="buttonBar">
									<div class="smallButtons">
										<ul>
											<li class="extraButton"><a href="#top" title="{lang}wcf.global.scrollUp{/lang}"><img src="{icon}upS.png{/icon}" alt="{lang}wcf.global.scrollUp{/lang}" /> <span class="hidden">{lang}wcf.global.scrollUp{/lang}</span></a></li>
										</ul>
									</div>
								</div>
							</div>
							{if $photo->isCommentable()}{assign var=username value=$commentUsername}{/if}
						{/if}
					
						{if $photo->isCommentable() && $action != 'edit'}
							<div class="contentBox">
								<form method="post" action="index.php?page=UserGalleryPhoto&amp;photoID={@$photoID}&amp;action=add">
									<fieldset>
										<legend>{lang}wcf.user.gallery.photo.comment.add{/lang}</legend>
										
										{if !$this->user->userID}
											<div class="formElement{if $errorField == 'username'} formError{/if}">
												<div class="formFieldLabel">
													<label for="username">{lang}wcf.user.username{/lang}</label>
												</div>
												<div class="formField">
													<input type="text" class="inputText" name="username" id="username" value="{$username}" />
													{if $errorField == 'username'}
														<p class="innerError">
															{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
															{if $errorType == 'notValid'}{lang}wcf.user.error.username.notValid{/lang}{/if}
															{if $errorType == 'notAvailable'}{lang}wcf.user.error.username.notUnique{/lang}{/if}
														</p>
													{/if}
												</div>
											</div>
										{/if}
										
										<div class="formElement{if $errorField == 'comment' && $action == 'add'} formError{/if}">
											<div class="formFieldLabel">
												<label for="comment">{lang}wcf.user.gallery.photo.comment{/lang}</label>
											</div>
											<div class="formField">
												<textarea name="comment" id="comment" rows="10" cols="40">{$comment}</textarea>
												{if $errorField == 'comment' && $action == 'add'}
													<p class="innerError">
														{if $errorType == 'empty'}{lang}wcf.global.error.empty{/lang}{/if}
														{if $errorType == 'tooLong'}{lang}wcf.user.gallery.photo.comment.error.tooLong{/lang}{/if}
													</p>
												{/if}
											</div>
										</div>
										
										{include file='captcha' enableFieldset=false}
									</fieldset>
									
									<div class="formSubmit">
										<input type="submit" accesskey="s" value="{lang}wcf.global.button.submit{/lang}" />
										<input type="reset" accesskey="r" value="{lang}wcf.global.button.reset{/lang}" />
										
										{@SID_INPUT_TAG}
									</div>
								</form>
							</div>
						{/if}
						
						{if $additionalContent1|isset}{@$additionalContent1}{/if}
					</div>
				</div>
				
				<div class="container-3 column second gallerySidebar">
					<div class="columnInner">
						
						{if $previousPhoto || $nextPhoto}
							<div class="contentBox photoNavigation">
								<div class="border">
									<div class="containerHead">
										<h3>{if $view == 'album' && $photo->albumID != 0}{$album->title}{else}{lang}wcf.user.gallery.photos.by{/lang}{/if}</h3>
									</div>
									<ul class="dataList thumbnailView squared floatContainer container-1">
										{if $previousPhoto}
											<li class="floatedElement photoPrevious">
												<a href="index.php?page=UserGalleryPhoto&amp;photoID={@$previousPhoto->photoID}{if $view == 'album' && $photo->albumID != 0}&amp;view=album{/if}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photo.previous{/lang}">
													<span class="thumbnail"><img src="{@$previousPhoto->getPhoto('quadratic')}" alt="" /></span>
													<span class="avatarCaption smallFont">{lang}wcf.user.gallery.photo.previous{/lang}</span>
												</a>
											</li>
										{else}
											<li class="floatedElement photoFirst">
												<span class="thumbnail"><img src="{@RELATIVE_WCF_DIR}images/galleryNoImage.png" alt="" title="{lang}wcf.user.gallery.photo.previous.start{/lang}" /></span>
												<span class="avatarCaption smallFont">{lang}wcf.user.gallery.photo.previous.start{/lang}</span>
											</li>
										{/if}
										<li class="floatedElement photoThis">
											<span class="thumbnail" style="width: {@$photo->getQuadraticWidth()}px;"><img src="{@$photo->getPhoto('quadratic')}" alt="" title="{$photo->title}" /></span>
											<span class="avatarCaption smallFont">{$photo->title}</span>
										</li>
										{if $nextPhoto}
											<li class="floatedElement photoNext">
												<a href="index.php?page=UserGalleryPhoto&amp;photoID={@$nextPhoto->photoID}{if $view == 'album' && $photo->albumID != 0}&amp;view=album{/if}{@SID_ARG_2ND}#profileContent" title="{lang}wcf.user.gallery.photo.next{/lang}">
													<span class="thumbnail"><img src="{@$nextPhoto->getPhoto('quadratic')}" alt="" /></span>
													<span class="avatarCaption smallFont">{lang}wcf.user.gallery.photo.next{/lang}</span>
												</a>
											</li>
										{else}
											<li class="floatedElement photoLast">
												<span class="thumbnail"><img src="{@RELATIVE_WCF_DIR}images/galleryNoImage.png" alt="" title="{lang}wcf.user.gallery.photo.next.end{/lang}" /></span>
												<span class="avatarCaption smallFont">{lang}wcf.user.gallery.photo.next.end{/lang}</span>
											</li>
										{/if}
									</ul>
								</div>
							</div>
						{/if}
						
						<div class="contentBox galleryImageDetailsListbox">
							<div class="border">
								<div class="containerHead">
									<h3>{lang}wcf.user.gallery.photo.general{/lang}</h3>
								</div>
								
								<ul class="dataList">
									{if $photo->albumID != 0}
										<li class="{cycle values='container-1,container-2'}">
											<div class="containerIcon">
												<img src="{icon}galleryAlbumM.png{/icon}" alt="" />
											</div>
											<div class="containerContent">
												<h4 class="smallFont">{lang}wcf.user.gallery.album{/lang}</h4>
												<p><a href="index.php?page=UserGalleryPhotos&amp;albumID={@$photo->albumID}{@SID_ARG_2ND}#profileContent">{$album->title}</a></p>
											</div>
										</li>
									{/if}
									<li class="{cycle values='container-1,container-2'}">
										<div class="containerIcon">
											<img src="{icon}galleryFilenameM.png{/icon}" alt="" />
										</div>
										<div class="containerContent">
											<h4 class="smallFont">{lang}wcf.user.gallery.photo.filename{/lang}</h4>
											<p>{$photo->filename}</p>
										</div>
									</li>
									{if $photo->creationTime != 0}
										<li class="{cycle values='container-1,container-2'}">
											<div class="containerIcon">
												<img src="{icon}cameraFlashM.png{/icon}" alt="" />
											</div>
											<div class="containerContent">
												<h4 class="smallFont">{lang}wcf.user.gallery.photo.creationTime{/lang}</h4>
												<p>{@$photo->creationTime|time}</p>
											</div>
										</li>
									{/if}
									<li class="{cycle values='container-1,container-2'}">
										<div class="containerIcon">
											<img src="{icon}galleryUploadM.png{/icon}" alt="" />
										</div>
										<div class="containerContent">
											<h4 class="smallFont">{lang}wcf.user.gallery.photo.uploadTime{/lang}</h4>
											<p>{@$photo->uploadTime|time}</p>
										</div>
									</li>
									<li class="{cycle values='container-1,container-2'}">
										<div class="containerContent">
											<h4 class="smallFont">{lang}wcf.user.gallery.photo.size{/lang}</h4>
											<p>{@$photo->width}x{@$photo->height} ({@$photo->getAspectRatio()})</p>
										</div>
									</li>
									<li class="{cycle values='container-1,container-2'}">
										<div class="containerContent">
											<h4 class="smallFont">{lang}wcf.user.gallery.photo.filesize{/lang}</h4>
											<p>{@$photo->filesize|filesize} {if $this->user->userID == $user->userID}({lang}wcf.user.gallery.photo.filesize.all{/lang}){/if}</p>
										</div>
									</li>
									{*<li class="{cycle values='container-1,container-2'}">
										<div class="containerContent">
											<h4 class="smallFont">{lang}wcf.user.gallery.photo.usedQuota{/lang}</h4>
											<p>{@$photo->usedQuota|filesize}</p>
										</div>
									</li>*}
									<li class="{cycle values='container-1,container-2'}">
										<div class="containerIcon">
											<img src="{icon}visitsM.png{/icon}" alt="" />
										</div>
										<div class="containerContent">
											<h4 class="smallFont">{lang}wcf.user.gallery.photo.views{/lang}</h4>
											<p>{#$photo->views}{if $photo->getViewsPerDay() > 0} ({lang}wcf.user.gallery.photo.viewsPerDay{/lang}){/if}</p>
										</div>
									</li>
									{if $photo->camera != ''}
										<li class="{cycle values='container-1,container-2'}">
											<div class="containerIcon">
												<img src="{icon}cameraM.png{/icon}" alt="" />
											</div>
											<div class="containerContent">
												<h4 class="smallFont">{lang}wcf.user.gallery.photo.camera{/lang}</h4>
												<p>{$photo->camera}</p>
											</div>
										</li>
									{/if}
									{if $photo->latitude != 0.0 && $photo->longitude != 0.0}
										<li class="{cycle values='container-1,container-2'}">
											<div class="containerIcon">
												<img src="{icon}mapM.png{/icon}" alt="" />
											</div>
											<div class="containerContent">
												<h4 class="smallFont">{lang}wcf.user.gallery.photo.coordinate{/lang}</h4>
												<p>{@$photo->getCoordinates()}</p>
											</div>
										</li>
									{/if}
									
									{if $additionalContent2|isset}{@$additionalContent2}{/if}
								</ul>
							</div>
						</div>
						
						{if $photo->latitude != 0.0 && $photo->longitude != 0.0}
							<div class="hidden" id="locationMap">
								<div class="contentBox">
									<div class="border">
										<div class="containerHead">
											<h3>{lang}wcf.gmap.map{/lang}</h3>
										</div>
										<div class="container-1" id="locationMapCanvas" style="height: 250px"></div>
									</div>
								</div>
							</div>
							
							{include file='gmapSingleLocation' id='locationMap' latitude=$photo->latitude longitude=$photo->longitude}
							
							<script type="text/javascript">
								//<![CDATA[
								GMAP_MAP_CONTROL = 'small';
								GMAP_MAPTYPE_CONTROL = 'off';
								GMAP_ENABLE_OVERVIEW_MAP_CONTROL = 0;
								GMAP_ENABLE_SCALE_CONTROL = 0;
								GMAP_ZOOM = 8;
								//]]>
							</script>
						{/if}
						
						{if $tags|count > 0}
							<div class="contentBox galleryTagListbox">
								<div class="border">
									<div class="containerHead">
										<h3>{lang}wcf.tagging.tags.used{/lang}</h3>
									</div>
									<div class="container-1">
										<div class="tagList">
											{implode from=$tags item=tag}<a href="index.php?page=UserGalleryPhotos&amp;userID={@$userID}&amp;tagID={@$tag->getID()}{@SID_ARG_2ND}#profileContent">{$tag->getName()}</a>{/implode}
										</div>
									</div>
								</div>
							</div>
						{/if}
						
						{if $photo->hasSmallThumbnail || ($photo->width <= 240 && $photo->height <= 240)}
							<div class="contentBox galleryLinkBox">
								<div class="border">
									<div class="containerHead">
										<h3>{lang}wcf.user.gallery.photo.share{/lang}</h3>
									</div>
									
									<ul class="dataList">
										<li class="{cycle values='container-1,container-2'}">
											<div class="containerIcon">
												<img src="{icon}wysiwyg/linkInsertM.png{/icon}" alt="" onclick="document.getElementById('userPhotoLink').select()" />
											</div>
											<div class="containerContent">
												<h4 class="smallFont" onclick="document.getElementById('userPhotoLink').select()">{lang}wcf.user.gallery.photo.link{/lang}</h4>
												<p><input type="text" class="inputText" id="userPhotoLink" readonly="readonly" onclick="this.select()" value="{PAGE_URL}/index.php?page=UserGalleryPhoto&amp;photoID={@$photoID}" /></p>
											</div>
										</li>
										<li class="{cycle values='container-1,container-2'}">
											<div class="containerIcon">
												<img src="{icon}embedImageM.png{/icon}" alt="" onclick="document.getElementById('userPhotoEmbed').select()" />
											</div>
											<div class="containerContent">
												<h4 class="smallFont" onclick="document.getElementById('userPhotoEmbed').select()">{lang}wcf.user.gallery.photo.embed{/lang}</h4>
												<p><input type="text" class="inputText" id="userPhotoEmbed" readonly="readonly" onclick="this.select()" value="[url={PAGE_URL}/index.php?page=UserGalleryPhoto&amp;photoID={@$photoID}][img]{PAGE_URL}/{$photo->getPhoto('small')}[/img][/url]" /></p>
											</div>
										</li>
									</ul>
								</div>
							</div>
						{/if}
						
						{if $additionalContent3|isset}{@$additionalContent3}{/if}
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

{include file='footer' sandbox=false}
</body>
</html>
